USE STAMM
GO


--- ApplicationVersion ---
IF EXISTS (SELECT name FROM sysobjects WHERE name = 'ApplicationVersion' AND type = 'U')
  DROP TABLE ApplicationVersion
GO
CREATE TABLE ApplicationVersion
(
    RechnerName    varchar(32)   NOT NULL
  , VersionNr      varchar(32)   NOT NULL
  , CreateDate     datetime      NOT NULL
)
GO
CREATE UNIQUE INDEX ApplicationVersionIdx0 ON ApplicationVersion (RechnerName, VersionNr)
GO

--- TablesVersion ---
IF EXISTS (SELECT name FROM sysobjects WHERE name = 'TablesVersion' AND type = 'U')
  DROP TABLE TablesVersion
GO
CREATE TABLE TablesVersion
(
    TabName    varchar(32)   PRIMARY KEY
  , VersionNr  int           NOT NULL
  , CreateDate datetime      NOT NULL
)
GO

--- Konsolidierung ---
IF EXISTS (SELECT name FROM sysobjects WHERE name = 'Konsolidierung' AND type = 'U')
  DROP TABLE Konsolidierung
GO
CREATE TABLE Konsolidierung
(
    SchemaName    varchar(32)   PRIMARY KEY
  , CreateDate datetime         NOT NULL
)
GO

---RTFTexte ---
IF EXISTS (SELECT name FROM sysobjects WHERE name = 'RTFTexte' AND type = 'U')
  DROP TABLE RTFTexte
GO
CREATE TABLE RTFTexte
(  
   Bezeichnung              varchar(50)        PRIMARY KEY
 , RTFText 			        image              NULL 
)
GO
CREATE UNIQUE INDEX RTFTexte_Idx0 ON RTFTexte (Bezeichnung)
GO

--- Formulartexte ---
IF EXISTS (SELECT name FROM sysobjects WHERE name = 'FormularTexte' AND type = 'U')
  DROP TABLE FormularTexte
GO
CREATE TABLE FormularTexte
(
   TextNr                   Int                PRIMARY KEY
 , Bezeichnung              varchar(50)        NULL
 , Kopftext                 image              NULL
 , KopftextTop              smallInt           NULL   
 , KopftextLeft             smallInt           NULL   
 , KopftextHeight           smallInt           NULL   
 , KopftextWidth            smallInt           NULL   
 , Fusstext                 image              NULL   
 , FusstextTop              smallInt           NULL   
 , FusstextLeft             smallInt           NULL   
 , FusstextHeight           smallInt           NULL   
 , FusstextWidth            smallInt           NULL   
 , Kopflogo                 image              NULL   
 , KopflogoTop              smallInt           NULL   
 , KopflogoLeft             smallInt           NULL   
 , KopflogoHeight           smallInt           NULL   
 , KopflogoWidth            smallInt           NULL   
 , Fusslogo                 image              NULL   
 , FusslogoTop              smallInt           NULL   
 , FusslogoLeft             smallInt           NULL   
 , FusslogoHeight           smallInt           NULL   
 , FusslogoWidth            smallInt           NULL
 , OrtsangabeStempel        varchar(50)        NULL
 , PageTopMargin            smallInt           NULL 
 , PageLeftMargin           smallInt           NULL 
 , PageRightMargin          smallInt           NULL 
 , PageBottomMargin         smallInt           NULL
 , PrinterName              varchar(100)       NULL  
 , Brieffenstertext         varchar(100)       NULL
 , ZusatztextQuittungen     image              NULL
)
GO
CREATE UNIQUE INDEX FormularTexte_Idx0 ON FormularTexte (TextNr,Bezeichnung)
GO

--- Monats Bezeichnungen ---
IF EXISTS (SELECT name FROM sysobjects WHERE name = 'MonatsBez' AND type = 'U')
  DROP TABLE MonatsBez
GO
CREATE TABLE MonatsBez
(
   Monat           TinyInt    PRIMARY KEY
 , MonatShortName  varchar(3) NOT NULL 
 , MonatLongName   varchar(9) NOT NULL
)
GO
INSERT INTO MonatsBez VALUES (1, 'Jan', 'Januar')
INSERT INTO MonatsBez VALUES (2, 'Feb', 'Februar')
INSERT INTO MonatsBez VALUES (3, 'Mrz', 'Mrz')
INSERT INTO MonatsBez VALUES (4, 'Apr', 'April')
INSERT INTO MonatsBez VALUES (5, 'Mai', 'Mai')
INSERT INTO MonatsBez VALUES (6, 'Jun', 'Juni')
INSERT INTO MonatsBez VALUES (7, 'Jul', 'Juli')
INSERT INTO MonatsBez VALUES (8, 'Aug', 'August')
INSERT INTO MonatsBez VALUES (9, 'Sep', 'September')
INSERT INTO MonatsBez VALUES (10,'Okt', 'Oktober')
INSERT INTO MonatsBez VALUES (11,'Nov', 'November')
INSERT INTO MonatsBez VALUES (12,'Dez', 'Dezember')
GO



--- Bundeslaender ---
IF EXISTS (SELECT name FROM sysobjects WHERE name = 'Bundeslaender' AND type = 'U')
  DROP TABLE Bundeslaender
GO
CREATE TABLE Bundeslaender
(
   Bundesland_Id    TinyInt      PRIMARY KEY
 , Bundesland       varchar(22)  NOT NULL
)
GO
INSERT INTO Bundeslaender VALUES (0,  'unbekannt')
INSERT INTO Bundeslaender VALUES (10, 'Baden-Wrttemberg')
INSERT INTO Bundeslaender VALUES (11, 'Bayern')
INSERT INTO Bundeslaender VALUES (7,  'Berlin')
INSERT INTO Bundeslaender VALUES (13, 'Brandenburg')
INSERT INTO Bundeslaender VALUES (4,  'Bremen')
INSERT INTO Bundeslaender VALUES (5,  'Hamburg')
INSERT INTO Bundeslaender VALUES (6,  'Hessen')
INSERT INTO Bundeslaender VALUES (12, 'Mecklenburg-Vorpommern')
INSERT INTO Bundeslaender VALUES (3,  'Nordrhein-Westpfalen')
INSERT INTO Bundeslaender VALUES (1,  'Niedersachsen')
INSERT INTO Bundeslaender VALUES (8,  'Rheinland-Pfalz')
INSERT INTO Bundeslaender VALUES (9,  'Saarland')
INSERT INTO Bundeslaender VALUES (16, 'Sachsen')
INSERT INTO Bundeslaender VALUES (14, 'Sachen-Anhalt')
INSERT INTO Bundeslaender VALUES (2,  'Schleswig-Holstein')
INSERT INTO Bundeslaender VALUES (15, 'Thringen')
GO




--- Apotheken ---
IF EXISTS (SELECT name FROM sysobjects WHERE name = 'Apotheken' AND type = 'U')
  DROP TABLE Apotheken
GO
CREATE TABLE Apotheken
(
   ApoIK            int 
 , AbrechnungsMonat int                     --- JJJJMM ---
 , Mandant          varchar(10)       NULL  --- NARZ/NRW/NDT/BERLIN
 , InterneNr        varchar(5)        NULL
 , Inhaber          varchar(40)       NULL
 , ApoName          varchar(40)       NULL
 , Strasse          varchar(40)       NULL
 , Plz              varchar(10)       NULL
 , Ort              varchar(40)       NULL
 , Nation           varchar(3)        
 , Bundesland_Id    TinyInt           
 , IsHauptApo       Bit              
 , HauptApoIK       int               NULL --- Wenn Feld gefllt dann IsFiliale == True ---
 , IsFilialApo      Bit              
 , IsApotheke       Bit              
 , IsKrankenhausApo Bit              
 , IsSanitaetshaus  Bit              
 , IsVersandApo     Bit              
 , IsUmschreiber    Bit              
 , Filialen         varchar(250)      NULL
)
GO
CREATE UNIQUE INDEX Apotheken_Idx0 ON Apotheken (ApoIK, AbrechnungsMonat)
GO

--- ApoGrp ---
IF EXISTS (SELECT name FROM sysobjects WHERE name = 'ApoGrp' AND type = 'U')
  DROP TABLE ApoGrp
GO
CREATE TABLE ApoGrp
(
   ApoGrNr          int  PRIMARY KEY
 , Gruppenname      varchar(200)
 , Bemerkung        varchar(200) NULL
 , IsAktiv          bit
 , ApoIK            int --- Wenn gefllt handelt es sich um die Einzelapotheke, also Pseudogruppe (jede Einzelapotheke wird fr sich als Gruppe definiert). ---
)
GO

--- ApoGrpZuord ---
IF EXISTS (SELECT name FROM sysobjects WHERE name = 'ApoGrpZuord' AND type = 'U')
  DROP TABLE ApoGrpZuord
GO
CREATE TABLE ApoGrpZuord
(
   ApoGrNr          int     
 , ApoIK            int
)
GO

IF EXISTS (SELECT name FROM sysobjects WHERE name = 'PrivatePublicKeys' AND type = 'U')
  DROP TABLE PrivatePublicKeys
GO
CREATE TABLE PrivatePublicKeys
(
   ApoIK      int 
 , Gueltig    int  --- JJJJMMTT ---
 , UnGueltig  int  --- JJJJMMTT ---
 , PuK        varchar(400)
 , PrK        varchar(1700)
) 
GO
CREATE UNIQUE INDEX PrivatePublicKeys_Idx0 ON PrivatePublicKeys (ApoIK, GUELTIG, UNGUELTIG)
GO



--- RZs ---
-----------
IF EXISTS (SELECT name FROM sysobjects WHERE name = 'RZs' AND type = 'U')
  DROP TABLE RZs
GO
CREATE TABLE RZs
(
   RZId             int PRIMARY KEY
 , Name             varchar(100)
 , Kurzname         varchar(100)
 , Strasse          varchar(100)
 , Plz              varchar(10)
 , Ort              varchar(100)
 , Telefon          varchar(30)  NULL
 , FAX              varchar(30)  NULL
 , eMail            varchar(30)  NULL
 , WebSeite         varchar(50)  NULL
 , Hotline          varchar(100) NULL
 , PuK              varchar(400) 
)
GO
INSERT INTO RZs Values
(
   1
 , 'NARZ-AVN Serviceverbund'
 , 'NARZ-AVN'
 , 'Bauerland 3'
 , 28259
 , 'Bremen'
 , '0421 - 57 62 0'
 , '0421 - 57 62 299'
 , 'hotline@narz-avn.de'
 , 'www.narz-avn.de'
 , '0421 - 57 62 126 / 129'
 , 'MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAny8+cKI4qaCKDlkRjdCQ4xCqJR3OdxH+ZBygeKiItGDqQUCboSVRYAtqPPNLZFLfG/LI559n3h6S276leN1kQ7bJdUab9IX6aFS4FI6jqrCndSWuA9hE9/on52tbZPKnIqLw0vNYmtQCePzpDzwuH23QJRvItFYHpZDM5+4+DjVBThzhtXYuHSmZXAG7DWz5ucdwiB+bB2MqWgpC4+C2IVOJf1wA8jG8USkl5PTjEHWGmSIhRF0iDa0SUwr4s2DES5ivttYc//NiStDcTx9PLV1OFbiFk09ktLPnLP/wGcw801VDHMdWw7IYNWYiDTf7JUnyv5cKipAbxOcrpImpAQIDAQAB'
 )
GO


--- Benutzer ---
----------------
IF EXISTS (SELECT name FROM sysobjects WHERE name = 'Benutzer' AND type = 'U')
  DROP TABLE Benutzer
GO
CREATE TABLE Benutzer
(
   BenutzerNr       int PRIMARY KEY
 , BenutzerName     varchar(40)
 , Beschreibung     varchar(100)
 , Passwort         varchar(56)
 , IsAktiv          bit
)
GO
CREATE UNIQUE Index Benutzer_Idx0 On Benutzer (BenutzerName)
GO
INSERT INTO Benutzer Values (1, 'Administrator', 'Dieser administrations Benutzer besitzt ALLE Zugriffsrechte!', 'D5A99288B270B6C1989975FDB352425913C45E1640B35473EF9370FC', 1)  --- 111111 --- --- qwe123qwe456qwe789 == 275FBAF38ECC91484CA2C09B66068649414783BC3FB3A50C5649A341 ---
GO


--- BenutzerGrp ---
-------------------
IF EXISTS (SELECT name FROM sysobjects WHERE name = 'BenutzerGrp' AND type = 'U')
  DROP TABLE BenutzerGrp
GO
CREATE TABLE BenutzerGrp
(
   BenutzerGrpNr       int PRIMARY KEY
 , BenutzerGrpName     varchar(80)
 , Beschreibung        varchar(140)
 , IsBenutzer          bit             --- Fr jeden Benutzer wird ein BenutzerGrp Eintrag angelegt der NICHT angezeigt wird, um die Verwaltung zu vereinfachen. ---
 , IsAktiv             bit
)
GO
CREATE UNIQUE INDEX BenutzerGrp_Idx0 ON BenutzerGrp (BenutzerGrpName)
GO
INSERT INTO BenutzerGrp VALUES (1,'Administratorgruppe', 'Diese administrations Benutzergruppe besitzt ALLE Zugriffsrechte!', 1, 1)
INSERT INTO BenutzerGrp VALUES (100001,'Eingeschrnkte Benutzergruppe fr alle Apotheken', 'Diese Benutzergruppe besitzt KEINE Zugriffsrechte auf Statistiken mit Umsatzdaten', 0, 1)
INSERT INTO BenutzerGrp VALUES (100002,'ALLE ApoInfoDienste Online-Benutzergruppe fr alle Apotheken', 'Diese Benutzergruppe besitzt eingeschrnkten Zugriff auf die apoinfodienste aller Apotheken.', 0, 1)
INSERT INTO BenutzerGrp VALUES (100003,'apokorrektur & Rabattvertragsprfung fr alle Apotheken', 'Diese Benutzergruppe hat nur Zugriff auf die apokorrektur und die Rabattvertragsprfung aller Apotheken.', 0, 1)
GO

--- BenutzerGrpZuord ---
------------------------
IF EXISTS (SELECT name FROM sysobjects WHERE name = 'BenutzerGrpZuord' AND type = 'U')
  DROP TABLE BenutzerGrpZuord
GO
CREATE TABLE BenutzerGrpZuord
(
   BenutzerGrpNr       int 
 , BenutzerNr          int 
)
GO
INSERT INTO BenutzerGrpZuord Values (1, 1)
GO
CREATE UNIQUE INDEX BenutzerGrpZuord_Idx0 ON BenutzerGrpZuord (BenutzerGrpNr, BenutzerNr)
GO


--- FuncNrClickCount ---
------------------------
IF EXISTS (SELECT name FROM sysobjects WHERE name = 'FuncNrUseCount' AND type = 'U')
  DROP TABLE FuncNrUseCount
GO  
CREATE TABLE FuncNrUseCount
(
   BenutzerNr            int
 , FuncNr                int 
 , UseCounter            int  
) 
GO
CREATE UNIQUE INDEX FuncNrUseCount_Idx0 ON FuncNrUseCount (BenutzerNr, FuncNr)
GO


--- Favoriten ---
------------------
IF EXISTS (SELECT name FROM sysobjects WHERE name = 'Favoriten' AND type = 'U')
  DROP TABLE Favoriten
GO  
CREATE TABLE Favoriten
(
   BenutzerNr            int
 , FuncNr                int 
 , Rang                  int  
) 
GO
CREATE UNIQUE INDEX Favoriten_Idx0 ON Favoriten (BenutzerNr, FuncNr)
GO


--- Funktionen ---
------------------
IF EXISTS (SELECT name FROM sysobjects WHERE name = 'Funktionen' AND type = 'U')
  DROP TABLE Funktionen
GO  
CREATE TABLE Funktionen
(
   FuncNr                int PRIMARY KEY
 , FuncNameShort         varchar(50)
 , FuncNameLong          varchar(50)
 , Beschreibung          varchar(120)  
 , FuncGrpNr             int
 , IsApothekenSpezifisch Bit
)
GO
CREATE UNIQUE INDEX Funktionen_Idx0 ON Funktionen (FuncNr)
GO

--- Einstellungen ---
INSERT INTO Funktionen Values (100001, 'Allgemeine Einstellungen',          NULL, 'Konfiguration Ihrer Apotheken-CD XL.',                                                           100000, 0)
INSERT INTO Funktionen Values (100002, 'Benutzerverwaltung/Zugriffsrechte', NULL, 'Hinzufgen/ndern/Lschen von Benutzern und deren Zugriffsrechte innerhalb der Apotheken-CD.',                100000, 0)
INSERT INTO Funktionen Values (100003, 'Benutzer wechseln',                 NULL, 'Sie knnen unter Angabe des Passwortes zu einem anderen Benutzerprofil innerhalb der Apotheken-CD wechseln.', 100000, 0)
INSERT INTO Funktionen Values (100004, 'Benutzung sperren',                 NULL, 'Sperrt die Benutzung der Apotheken-CD XL.', 100000, 0)

--- Stammdaten ---
INSERT INTO Funktionen Values (200001, 'Apothekengruppen',                 NULL, 'Hinzufgen/ndern/Lschen von Apothekengruppen.',       200000, 0)
INSERT INTO Funktionen Values (200002, 'rztedatenbank',                   NULL, 'Hinzufgen/ndern/Lschen von rzten.'          ,       200000, 0)
INSERT INTO Funktionen Values (200003, 'rztegruppen',                     NULL, 'Hinzufgen/ndern/Lschen von rztegruppen.'    ,       200000, 0)
INSERT INTO Funktionen Values (200004, 'Betriebsstttendatenbank',         NULL, 'Hinzufgen/ndern/Lschen von Betriebssttten.' ,       200000, 0)
INSERT INTO Funktionen Values (200005, 'Betriebsstttengruppen',           NULL, 'Hinzufgen/ndern/Lschen von Betriebsstttengruppen.', 200000, 0)
INSERT INTO Funktionen Values (200006, 'Kundendatenbank',                  NULL, 'Hinzufgen/ndern/Lschen von Kunden.',                 200000, 0)
INSERT INTO Funktionen Values (200007, 'Kundengruppen',                    NULL, 'Hinzufgen/ndern/Lschen von Kundengruppen.',          200000, 0)
INSERT INTO Funktionen Values (200008, 'Datenbestnde lschen/anzeigen',   NULL, 'Verwaltung der Datenbestnde Ihrer Apotheke(n).',       200000, 1)
INSERT INTO Funktionen Values (200009, 'Datentransfer (Online und von CD)',NULL, 'Datentransfer von CD-ROM oder Onlineabruf aus dem RZ.', 200000, 0)
INSERT INTO Funktionen Values (200010, 'Datensicherung',                   NULL, 'Datensicherung aller von "Ihnen" erfassten Daten.',     200000, 0)

--- Kunden ---
---INSERT INTO Funktionen Values (300001, 'Geburtstagsliste',   'Geburtstagsliste der Kunden'          , 'Erstellt eine Geburtstagsliste ausgewhlter Kunden z. B. Jubilum.',    300000, 1)
INSERT INTO Funktionen Values (300002, 'Medikamentenliste',  'Medikamentenliste fr Kunden/Gruppe'  , 'Erstellt eine Medikamentenliste fr einen Kunden oder Kundengruppe.',   300000, 1)
INSERT INTO Funktionen Values (300003, 'Zuzahlungsquittung', 'Zuzahlungsquittung fr Kunden/Gruppe' , 'Erstellt eine Zuzahlungsquittung fr einen Kunden oder Kundengruppe.',  300000, 0)


--- Recherche ---
INSERT INTO Funktionen Values (400001, 'Rezeptrecherche',                        NULL, 'Recherche in den transferierten Datenbestnden.',            400000, 1)
INSERT INTO Funktionen Values (400002, 'Rezept Journal (Memos zu Rezepten)',     NULL, 'Rezept Journal mit Ihren Vermerken zu wichtigen Rezepten.',  400000, 1)


--- Statistiken ---
-------------------
--- rzte ---
INSERT INTO Funktionen Values (510001, 'AMPreisV',            'rzte - AMPreisV Analyse'   , 'AMPreisV eines Arztes bzw. rztegruppen.',               510000, 1)
INSERT INTO Funktionen Values (510002, 'ATC-Code-Analyse',    'rzte - ATC-Code-Analyse'   , 'ATC-Code-Analyse eines Arztes bzw. rztegruppen.',       510000, 1)
INSERT INTO Funktionen Values (510003, 'Herstellerbersicht', 'rzte - Herstellerbersicht', 'Herstellerbersicht eines Arztes bzw. rztegruppen.',    510000, 1)
INSERT INTO Funktionen Values (510004, 'Medikamente',         'rzte - Medikamente'        , 'Medikamentenbersicht eines  Arztes bzw. rztegruppen.', 510000, 1)
INSERT INTO Funktionen Values (510005, 'Patientenbersicht',  'rzte - Patientenbersicht' , 'Patientenbersicht eines Arztes bzw. rztegruppen.',     510000, 1)
INSERT INTO Funktionen Values (510006, 'Umsatzentwicklung',   'rzte - Umsatzentwicklung'  , 'Umsatzentwicklung von rzten bzw. rztegruppen.',        510000, 1)

--- Apotheken ---
INSERT INTO Funktionen Values (520001, 'AMPreisV',                'Apotheken - AMPreisV Analyse'   , 'AMPreisV einer Apotheke bzw. Apothekengruppen.',                    520000, 1)
INSERT INTO Funktionen Values (520002, 'ATC-Code-Analyse',        'Apotheken - ATC-Code-Analyse'   , 'ATC-Code-Analyse einer Apotheke bzw. Apothekengruppen.',            520000, 1)
INSERT INTO Funktionen Values (520003, 'Herstellerbersicht',     'Apotheken - Herstellerbersicht', 'Herstellerbersicht einer Apotheke bzw. Apothekengruppen.',         520000, 1)
INSERT INTO Funktionen Values (520004, 'Importanalyse',           'Apotheken - Importanalyse'      , 'Importanalyse der Hauptapotheke inkl. Filialen o. Einzelapotheke.', 520000, 1)
INSERT INTO Funktionen Values (520005, 'Kundenbewegungs-Analyse', 'Kundenbewegungs-Analyse'        , 'bersicht der Neukunden, Stammkunden u. Verlorene Kunden.',         520000, 1)
INSERT INTO Funktionen Values (520006, 'Pachtzins-Analyse',       'Apotheken - Pachtzins-Analyse'  , 'Pachtzins-Analyse einer Apotheke bzw. Apothekengruppen.',           520000, 1)
INSERT INTO Funktionen Values (520007, 'Umsatzentwicklung',       'Apotheken - Umsatzentwicklung'  , 'Umsatzentwicklung von Apotheken bzw. Apothekengruppen.',            520000, 1)


--- Betriebsstaetten ---
INSERT INTO Funktionen Values (530001, 'AMPreisV',            'Betriebssttten - AMPreisV Analyse'   , 'AMPreisV einer Betriebssttte bzw. Betr.-Gruppen.',              530000, 1)
INSERT INTO Funktionen Values (530002, 'ATC-Code-Analyse',    'Betriebssttten - ATC-Code-Analyse'   , 'ATC-Code-Analyse einer Betriebssttte bzw. Betr.-Gruppen.',      530000, 1)
INSERT INTO Funktionen Values (530003, 'Herstellerbersicht', 'Betriebssttten - Herstellerbersicht', 'Herstellerbersicht einer Betriebssttte bzw. Betr.-Gruppen.',   530000, 1)
INSERT INTO Funktionen Values (530004, 'Medikamente',         'Betriebssttten - Medikamente'        , 'Medikamentenbersicht einer Betriebssttte bzw. Betr.-Gruppen.', 530000, 1)
INSERT INTO Funktionen Values (530005, 'Patientenbersicht',  'Betriebssttten - Patientenbersicht' , 'Patientenbersicht einer Betriebssttte bzw. Betr.-Gruppen.',    530000, 1)
INSERT INTO Funktionen Values (530006, 'Umsatzentwicklung',   'Betriebssttten - Umsatzentwicklung'  , 'Umsatzentwicklung einer Betriebssttte bzw. Betr.-Gruppen.',     530000, 1)


--- Kostentrger ---
INSERT INTO Funktionen Values (540001, 'ATC-Code-Analyse',    'Kostentrger - ATC-Code-Analyse'   , 'ATC-Code-Analyse nach Kostentrger(n).',      540000, 1)
INSERT INTO Funktionen Values (540002, 'Herstellerbersicht', 'Kostentrger - Herstellerbersicht', 'Herstellerbersicht nach Kostentrger(n).',   540000, 1)
INSERT INTO Funktionen Values (540003, 'Medikamente',         'Kostentrger - Medikamente'        , 'Medikamentenbersicht nach Kostentrger(n).', 540000, 1)
INSERT INTO Funktionen Values (540004, 'Patientenbersicht',  'Kostentrger - Patientenbersicht' , 'Patientenbersicht nach Kostentrger(n).',    540000, 1)


--- Rennerstatistiken ---
INSERT INTO Funktionen Values (550001, 'rzte',           'rzte-Rennerstatistik'          , 'Rennerbersicht der rzte und rztegruppen.',                               550000, 1)
INSERT INTO Funktionen Values (550002, 'Apotheken',       'Apotheken-Rennerstatistik'      , 'Rennerbersicht Ihrer Apotheke(n) und Apothekengruppen.',                   550000, 1)
INSERT INTO Funktionen Values (550003, 'ATC-Code',        'ATC-Code-Rennerstatistik'       , 'Rennerbersicht nach ATC-Code: Anatomisch-Therapeutisch-Chemischer-Code.',  550000, 1)
INSERT INTO Funktionen Values (550004, 'Betriebssttten', 'Betriebssttten-Rennerstatistik', 'Rennerbersicht der Betriebssttten und Betriebsstttengruppen.',           550000, 1)
INSERT INTO Funktionen Values (550005, 'Hersteller',      'Hersteller-Rennerstatistik'     , 'Rennerbersicht nach Herstellern.',                                         550000, 1)
INSERT INTO Funktionen Values (550006, 'Kostentrger',    'Kostentrger-Rennerstatistik'   , 'Rennerbersicht der Kostentrger.',                                         550000, 1)
INSERT INTO Funktionen Values (550007, 'Kunden',          'Kunden-Rennerstatistik'         , 'Rennerbersicht der Kunden und Kundengruppen.',                             550000, 1)
INSERT INTO Funktionen Values (550008, 'Medikamente',     'Medikamenten-Rennerstatistik'   , 'Rennerbersicht aller abgegebenen Medikamente (PZN`s).',                    550000, 1)
INSERT INTO Funktionen Values (550009, 'Zuzahlung',       'Zuzahlungs-Rennerstatistik'     , 'Rennerbersicht nach geleisteter Zuzahlung nach Kunden und Kundengruppen.', 550000, 1)

--- apoinfodienst ---
INSERT INTO Funktionen Values (600001, 'Anzeige/Abruf der Monatsabrechnung',        NULL, 'Anzeige/Abruf der Monatsabrechnung als PDF-Dokument.',                                     600000, 1)
INSERT INTO Funktionen Values (600002, 'apokorrektur',                              NULL, 'Online Korrektur der in Abrechnung befindlichen Rezepte.',                                 600000, 1)
INSERT INTO Funktionen Values (600003, 'Einlieferungsbersicht',                    NULL, 'bersicht der Rezept-Einlieferungen des aktuellen Abrechnungsmonats.',                     600000, 1)
INSERT INTO Funktionen Values (600004, 'Kategorisierung Ihrer Apotheke',            NULL, 'Kategorisieren Sie Ihre Apotheke, um sie mit anderen gleicher Kategorie zu vergleichen.',  600000, 1)
INSERT INTO Funktionen Values (600005, 'Preishistorie (Wie war nochmal der Preis)', NULL, 'Alle Fertigarzneimittelpreise seit 2002 stehen Ihnen Online zur Verfgung.',               600000, 1)
INSERT INTO Funktionen Values (600006, 'Rabattvertragsprfung',                     NULL, 'Rabattvertragsprfung einer Medikamentenabgabe.',                                          600000, 1)
INSERT INTO Funktionen Values (600007, 'Rezeptrecherche Online',                    NULL, 'Recherche in den Online-Datenbestnden des Rechenzentrums.',                               600000, 1)
INSERT INTO Funktionen Values (600008, 'Softwareupdate',                            NULL, 'Online Softwareupdate Ihrer Apotheken-CD XL.',                                             600000, 0)
INSERT INTO Funktionen Values (600009, 'Zuzahlungsquittung Online',                 NULL, 'Zuzahlungsquittung auf Basis der Online-Datenbestnden des Rechenzentrums.',               600000, 0)

--- apoplaner ---
INSERT INTO Funktionen Values (700001, 'Datenbernahme zum apoplaner',              NULL, 'Datenbernahme zum apoplaner.',                    700000, 0)

--- Info/Hilfe ---
INSERT INTO Funktionen Values (800001, 'Aktuelle Neuigkeiten',                     NULL, 'Neuigkeiten von NARZ/AVN.'                               ,  800000, 0)
INSERT INTO Funktionen Values (800002, 'www.narz-avn.de',                          NULL, 'Homepage des NARZ-AVN Serviceverbundes.'                 ,  800000, 0)
INSERT INTO Funktionen Values (800003, 'Download-Seite',                           NULL, 'Software Download aus dem Internet ber die Web-Seite.'  ,  800000, 0)
INSERT INTO Funktionen Values (800004, 'Fernwartung starten',                      NULL, 'Direkte Hilfe durch eine NARZ/AVN Mitarbeiter.'          ,  800000, 0)
GO


--- FunktionenGrp ---
---------------------
IF EXISTS (SELECT name FROM sysobjects WHERE name = 'FunktionenGrp' AND type = 'U')
  DROP TABLE FunktionenGrp
GO  
CREATE TABLE FunktionenGrp
(
   FuncGrpNr           int PRIMARY KEY
 , FuncGrpName         varchar(50)
 , Beschreibung        varchar(100)
)
GO
CREATE UNIQUE INDEX FunktionenGrp_Idx0 ON FunktionenGrp (FuncGrpNr)
GO

INSERT INTO FunktionenGrp Values (1,      'Top',                         'Die am meisten genutzen Funktionen eines Benutzers.')
INSERT INTO FunktionenGrp Values (2,      'Favoriten',                   'Benutzerdefinierte Favoriten.')
INSERT INTO FunktionenGrp Values (100000, 'Einstellungen',               'Einstellungen und Konfiguration der Apotheken-CD und des Datenbank-Servers')
INSERT INTO FunktionenGrp Values (200000, 'Stammdaten',                  'Verwalten von Apotheken/Gruppen, rzte/Gruppen, Kunden/Gruppen etc.')
INSERT INTO FunktionenGrp Values (300000, 'Kunden-Service',              'Services und Statistiken fr Kunden.')
INSERT INTO FunktionenGrp Values (400000, 'Recherche',                   'Rezeptrecherche und Rezept-Dokumentation.')
INSERT INTO FunktionenGrp Values (510000, 'rzte Statistiken',           'Statistiken auf Basis von rzten und rztegruppen.')
INSERT INTO FunktionenGrp Values (520000, 'Apotheken Statistiken',       'Statistiken auf Basis der Apotheke(n) und Apothekengruppen.')
INSERT INTO FunktionenGrp Values (530000, 'Betriebssttten Statistiken', 'Statistiken auf Basis von Betriebssttten und Betriebsstttengruppen.')
INSERT INTO FunktionenGrp Values (540000, 'Kostentrger Statistiken',    'Statistiken auf Basis der Kostentrger der Apotheke(n).')
INSERT INTO FunktionenGrp Values (550000, 'Rennerstatistiken',           'Rennerstatistiken fr rzte, Apotheken, ATC-Code, Kunden, Hersteller, Medikamente uvm.')
INSERT INTO FunktionenGrp Values (600000, 'apoinfodienst',               'apoinfodienst - Online Dienste von NARZ-AVN per Web-Service.')
INSERT INTO FunktionenGrp Values (700000, 'apoplaner',                   'Funktionen im Zusammenhang mit dem apoplaner.')
INSERT INTO FunktionenGrp Values (800000, 'Info/Hilfe',                  'Informationen und Hilfe rund um die Apotheken-CD XL.')
GO


--- RechteBenutzerGrp ---
-------------------------
IF EXISTS (SELECT name FROM sysobjects WHERE name = 'RechteBenutzerGrp' AND type = 'U')
  DROP TABLE RechteBenutzerGrp
GO 
CREATE TABLE RechteBenutzerGrp
(
   FuncNr           int
 , BenutzerGrpNr    int 
 , IsExec           bit
 , IsRead           bit
 , IsWrite          bit
 , IsPrint          bit
 , IsExport         bit
)
GO
CREATE UNIQUE INDEX RechteBenutzerGrp_Idx0 ON RechteBenutzerGrp (FuncNr, BenutzerGrpNr)
GO
INSERT INTO RechteBenutzerGrp VALUES (100001,100001,1,1,1,1,1)
INSERT INTO RechteBenutzerGrp VALUES (200002,100001,1,1,1,1,1)
INSERT INTO RechteBenutzerGrp VALUES (200003,100001,1,1,1,1,1)
INSERT INTO RechteBenutzerGrp VALUES (100003,100001,1,1,1,1,1)
INSERT INTO RechteBenutzerGrp VALUES (100004,100001,1,1,1,1,1)
INSERT INTO RechteBenutzerGrp VALUES (200009,100001,1,1,1,1,1)
INSERT INTO RechteBenutzerGrp VALUES (700001,100001,1,1,1,1,1)
INSERT INTO RechteBenutzerGrp VALUES (800003,100001,1,1,1,1,1)
INSERT INTO RechteBenutzerGrp VALUES (800004,100001,1,1,1,1,1)
INSERT INTO RechteBenutzerGrp VALUES (300001,100001,1,1,1,1,1)
INSERT INTO RechteBenutzerGrp VALUES (200006,100001,1,1,1,1,1)
INSERT INTO RechteBenutzerGrp VALUES (200007,100001,1,1,1,1,1)
INSERT INTO RechteBenutzerGrp VALUES (400001,100001,1,1,1,1,1)
INSERT INTO RechteBenutzerGrp VALUES (600006,100001,1,1,1,1,1)
INSERT INTO RechteBenutzerGrp VALUES (600007,100001,1,1,1,1,1)
INSERT INTO RechteBenutzerGrp VALUES (800002,100001,1,1,1,1,1)
INSERT INTO RechteBenutzerGrp VALUES (300003,100001,1,1,1,1,1)
INSERT INTO RechteBenutzerGrp VALUES (600008,100001,1,1,1,1,1)
INSERT INTO RechteBenutzerGrp VALUES (200001,100001,1,1,1,1,1)
INSERT INTO RechteBenutzerGrp VALUES (800001,100002,1,1,1,1,1)
INSERT INTO RechteBenutzerGrp VALUES (100001,100002,1,1,1,1,1)
INSERT INTO RechteBenutzerGrp VALUES (100003,100002,1,1,1,1,1)
INSERT INTO RechteBenutzerGrp VALUES (100004,100002,1,1,1,1,1)
INSERT INTO RechteBenutzerGrp VALUES (800003,100002,1,1,1,1,1)
INSERT INTO RechteBenutzerGrp VALUES (800004,100002,1,1,1,1,1)
INSERT INTO RechteBenutzerGrp VALUES (600003,100002,1,1,1,1,1)
INSERT INTO RechteBenutzerGrp VALUES (600004,100002,1,1,1,1,1)
INSERT INTO RechteBenutzerGrp VALUES (600005,100002,1,1,1,1,1)
INSERT INTO RechteBenutzerGrp VALUES (600006,100002,1,1,1,1,1)
INSERT INTO RechteBenutzerGrp VALUES (600007,100002,1,1,1,1,1)
INSERT INTO RechteBenutzerGrp VALUES (600008,100002,1,1,1,1,1)
INSERT INTO RechteBenutzerGrp VALUES (800001,100001,1,1,1,1,1)
INSERT INTO RechteBenutzerGrp VALUES (800002,100002,1,1,1,1,1)
INSERT INTO RechteBenutzerGrp VALUES (600009,100002,1,1,1,1,1)
INSERT INTO RechteBenutzerGrp VALUES (800001,100003,1,1,1,1,1)
INSERT INTO RechteBenutzerGrp VALUES (100001,100003,1,1,1,1,1)
INSERT INTO RechteBenutzerGrp VALUES (600002,100003,1,1,1,1,1)
INSERT INTO RechteBenutzerGrp VALUES (100003,100003,1,1,1,1,1)
INSERT INTO RechteBenutzerGrp VALUES (100004,100003,1,1,1,1,1)
INSERT INTO RechteBenutzerGrp VALUES (600006,100003,1,1,1,1,1)
INSERT INTO RechteBenutzerGrp VALUES (300002,100001,1,1,1,1,1)
INSERT INTO RechteBenutzerGrp VALUES (600009,100001,1,1,1,1,1)
GO

--- RechteBenutzerGrp4ApoGrp ---
--------------------------------
IF EXISTS (SELECT name FROM sysobjects WHERE name = 'RechteBenutzerGrp4ApoGrp' AND type = 'U')
  DROP TABLE RechteBenutzerGrp4ApoGrp
GO 
CREATE TABLE RechteBenutzerGrp4ApoGrp
(
   FuncNr              int
 , BenutzerGrpNr       int
 , ApoGrpNr            int  
)
GO
CREATE UNIQUE INDEX RechteBenutzerGrp4ApoGrp_Idx0 ON RechteBenutzerGrp4ApoGrp (FuncNr, BenutzerGrpNr, ApoGrpNr)
GO


--- Konfiguration ---
IF EXISTS (SELECT name FROM sysobjects WHERE name = 'Konfiguration' AND type = 'U')
  DROP TABLE Konfiguration
GO 
CREATE TABLE Konfiguration
(
   BenutzerNr  int          
 , FeldName    varchar(50)   
 , FeldWert    varchar(255)
 , FeldTyp     varchar(10)
)
GO
CREATE UNIQUE INDEX Konfiguration_Idx0 ON Konfiguration (BenutzerNr, FeldName)
GO


--- GlobalKonfiguration ---
IF EXISTS (SELECT name FROM sysobjects WHERE name = 'GlobalKonfiguration' AND type = 'U')
  DROP TABLE GlobalKonfiguration
GO 
CREATE TABLE GlobalKonfiguration
(
   FeldName    varchar(50)   PRIMARY KEY
 , FeldWert    varchar(255)
 , FeldTyp     varchar(10)
)
GO


--- Kunden ---
--------------
IF EXISTS (SELECT name FROM sysobjects WHERE name = 'Kunden' AND type = 'U')
  DROP TABLE Kunden
GO
CREATE TABLE Kunden
(
   KundenNr            int  PRIMARY KEY
 , Sex                 TinyInt  --- 0 == n/a    1 == Mann   2 == Frau
 , Titel               varchar(15)
 , Vorname             varchar(30)   NULL
 , Nachname            varchar(30)   NULL
 , Strasse             varchar(40)   NULL
 , Plz                 varchar(10)   NULL
 , Ort                 varchar(40)   NULL
 , Telefon             varchar(30)   NULL
 , Fax                 varchar(30)   NULL
 , EMail               varchar(50)   NULL
 , Geburtstag          SmallDateTime NULL
 , AnspNachname        varchar(30)   NULL --- fuer Pfl. HIMI
 , AnspVorname         varchar(30)   NULL --- fuer Pfl. HIMI
 , AnspTelefon         varchar(30)   NULL --- fuer Pfl. HIMI
 , Bemerkung           varchar(200)  NULL
 , LastRezept          SmallDateTime NULL
 , IsAmLeben           bit           
 , AngelegtAm          DateTime      NULL
 , AngelegtVon         int           NULL --- BenutzerNr
 , BearbeitetAm        DateTime      NULL 
 , BearbeitetVon       int           NULL --- BenutzerNr
 , ApothekenCardNr     bigint        NULL
 , IsHausApoModel      bit           
 , ZuzahlungBisJJJJMM  int           NULL --- Format JJJJMM
 , IsEinwilligung      bit
)
GO
CREATE UNIQUE INDEX Kunden_Idx0 ON Kunden (KundenNr)
GO

--- Standard-Nr. und Pseudo-Nr. anlegen ----
INSERT INTO Stamm..Kunden (KundenNr, Nachname) VALUES (-1, 'Standard Nr.')
INSERT INTO Stamm..Kunden (KundenNr, Nachname) VALUES (-2, 'Pseudo Nr.')
GO

--- VersNr ---
IF EXISTS (SELECT name FROM sysobjects WHERE name = 'VersichertenNr' AND type = 'U')
  DROP TABLE VersichertenNr
GO
CREATE TABLE VersichertenNr
(
   KundenNr         int
 , VersNr           varchar(12) 
 , KassenIK         int 
 , Datum_Ab         DateTime     NULL
 , Datum_Bis        DateTime     NULL
 , IsAktuell        bit        
)
GO
CREATE UNIQUE INDEX VersichertenNr_Idx0 ON VersichertenNr (KundenNr, VersNr, KassenIK)
GO


--- Standard-Nr. und Pseudo-Nr. anlegen ----
INSERT INTO Stamm..VersichertenNr VALUES (-1, '0', 0, '01.01.2000', '31.12.9999', 1)
INSERT INTO Stamm..VersichertenNr VALUES (-2, '1', 0, '01.01.2000', '31.12.9999', 1)
GO

--- PflVersNr ---
IF EXISTS (SELECT name FROM sysobjects WHERE name = 'PflVersichertenNr' AND type = 'U')
  DROP TABLE PflVersichertenNr
GO
CREATE TABLE PflVersichertenNr
(
   KundenNr         int
 , PflVersNr        varchar(12)   NULL
 , PflKassenIK      int           NULL
 , PflDatum_Ab      DateTime      NULL
 , PflDatum_Bis     DateTime      NULL
 , PflIsAktuell     bit        
)
GO
CREATE UNIQUE INDEX PflVersichertenNr_Idx0 ON PflVersichertenNr (KundenNr, PflVersNr, PflKassenIK)
GO




--- Seriendruck ---
IF EXISTS (SELECT name FROM sysobjects WHERE name = 'Seriendruck' AND type = 'U')
  DROP TABLE Seriendruck
GO
CREATE TABLE Seriendruck
(
  KundenNr         int PRIMARY KEY
)
GO


--- ZuzahlProtokoll ---
IF EXISTS (SELECT name FROM sysobjects WHERE name = 'ZuzahlProtokoll' AND type = 'U')
  DROP TABLE ZuzahlProtokoll
GO
CREATE TABLE ZuzahlProtokoll
(
   KundenNr         int
 , Von              varchar(6)
 , Bis              varchar(6)
 , IKs              varchar(500)
)
GO
CREATE UNIQUE INDEX ZuzahlProtokoll_Idx0 ON ZuzahlProtokoll (KundenNr)
GO


--- KundenGrp ---
IF EXISTS (SELECT name FROM sysobjects WHERE name = 'KundenGrp' AND type = 'U')
  DROP TABLE KundenGrp
GO
CREATE TABLE KundenGrp
(
   GrNr             int  PRIMARY KEY
 , Gruppenname      varchar(50)
 , Bemerkung        varchar(200) NULL
)
GO
CREATE UNIQUE INDEX KundenGrp_Idx0 On KundenGrp (Gruppenname)
GO

--- KundenGrpZuord ---
IF EXISTS (SELECT name FROM sysobjects WHERE name = 'KundenGrpZuord' AND type = 'U')
  DROP TABLE KundenGrpZuord
GO
CREATE TABLE KundenGrpZuord
(
   GrNr             int       
 , KundenNr         int
)
GO



--- Arzt ---
------------
IF EXISTS (SELECT name FROM sysobjects WHERE name = 'Arzt' AND type = 'U')
  DROP TABLE Arzt
GO
CREATE TABLE Arzt
(
   ArztNr           varchar(9)  PRIMARY KEY 
 , Titel            varchar(30)      NULL
 , Vorname          varchar(30)      NULL
 , Nachname         varchar(30) 
 , Strasse          varchar(30)      NULL
 , Plz              varchar(10)      NULL
 , Ort              varchar(30)      NULL
 , Telefon          varchar(30)      NULL
 , FAX              varchar(30)      NULL
 , eMail            varchar(50)      NULL
 , Fachgebiet       varchar(60)      NULL
 , Geburtstag       SmallDateTime    NULL
 , AnspNachname     varchar(30)      NULL
 , AnspVorname      varchar(30)      NULL
 , AnspTelefon      varchar(30)      NULL
 , Sex              TinyInt               --- 0 == n/a    1 == Mann   2 == Frau
 , Bemerkung        varchar(200)     NULL
 , AngelegtAm       DateTime         NULL
 , AngelegtVon      int              NULL --- BenutzerNr
 , BearbeitetAm     DateTime         NULL 
 , BearbeitetVon    int              NULL --- BenutzerNr
)
GO


IF EXISTS (SELECT name FROM sysobjects WHERE name = 'ArztBetrieb' AND type = 'U')
  DROP TABLE ArztBetrieb
GO
CREATE TABLE ArztBetrieb
(
   ArztNr           varchar(9)  
 , BetriebsNr       varchar(9)
)
GO
CREATE UNIQUE INDEX ArztBetrieb_Idx0 ON ArztBetrieb (ArztNr, BetriebsNr)
GO


IF EXISTS (SELECT name FROM sysobjects WHERE name = 'ArztGrp' AND type = 'U')
  DROP TABLE ArztGrp
GO
CREATE TABLE ArztGrp
(
   GrNr             int  PRIMARY KEY
 , Gruppenname      varchar(200)
 , Bemerkung        varchar(200) NULL
)
GO

IF EXISTS (SELECT name FROM sysobjects WHERE name = 'ArztGrpZuord' AND type = 'U')
  DROP TABLE ArztGrpZuord
GO
CREATE TABLE ArztGrpZuord
(
   GrNr             int        
 , ArztNr           varchar(9)
)
GO


IF EXISTS (SELECT name FROM sysobjects WHERE name = 'Betriebsstaetten' AND type = 'U')
  DROP TABLE Betriebsstaetten
GO
CREATE TABLE Betriebsstaetten
(
   BetriebsNr       varchar(9)    PRIMARY KEY
 , Bezeichnung      varchar(30)
 , Strasse          varchar(30)   NULL
 , Plz              varchar(10)   NULL
 , Ort              varchar(30)   NULL
 , Telefon          varchar(30)   NULL
 , FAX              varchar(30)   NULL
 , eMail            varchar(50)   NULL
 , Bemerkung        varchar(200)  NULL
 , AngelegtAm       DateTime      NULL
 , AngelegtVon      int           NULL --- BenutzerNr
 , BearbeitetAm     DateTime      NULL 
 , BearbeitetVon    int           NULL --- BenutzerNr
)
GO

IF EXISTS (SELECT name FROM sysobjects WHERE name = 'BetriebsstaettenGrp' AND type = 'U')
  DROP TABLE BetriebsstaettenGrp
GO
CREATE TABLE BetriebsstaettenGrp
(
   GrNr             int  PRIMARY KEY
 , Gruppenname      varchar(200)
 , Bemerkung        varchar(200) NULL
)
GO

IF EXISTS (SELECT name FROM sysobjects WHERE name = 'BetriebsstaettenGrpZuord' AND type = 'U')
  DROP TABLE BetriebsstaettenGrpZuord
GO
CREATE TABLE BetriebsstaettenGrpZuord
(
   GrNr             int        
 , BetriebsNr       varchar(9)
)
GO




--- Datensicherung ---
IF EXISTS (SELECT name FROM sysobjects WHERE name = 'Datensicherung' AND type = 'U')
  DROP TABLE Datensicherung
GO
CREATE TABLE Datensicherung
(
   TableName        varchar(40)
 , TableBezeichnung varchar(100)  
 , LetzteSicherung  DateTime     NULL
 , IsChecked        bit     
)
GO
CREATE UNIQUE INDEX Datensicherung_Idx0 ON Datensicherung (TableName)
GO

--- Tabellen anlegen ----
INSERT INTO Stamm..Datensicherung VALUES ('Arzt', 'rztestamm', Null, 1)
INSERT INTO Stamm..Datensicherung VALUES ('ArztBetrieb', 'rztebetriebsstttenzuordnung', Null, 1)
INSERT INTO Stamm..Datensicherung VALUES ('ArztGrp', 'rztegruppenstamm', Null, 1)
INSERT INTO Stamm..Datensicherung VALUES ('ArztGrpZuord', 'rztegruppenzuordnung', Null, 1)
INSERT INTO Stamm..Datensicherung VALUES ('Betriebsstaetten', 'Betriebsstttenstamm', Null, 1)
INSERT INTO Stamm..Datensicherung VALUES ('BetriebsstaettenGrp', 'Betriebsstttengruppenstamm', Null, 1)
INSERT INTO Stamm..Datensicherung VALUES ('BetriebsstaettenGrpZuord', 'Betriebsstttengruppenstammzuordnung', Null, 1)
INSERT INTO Stamm..Datensicherung VALUES ('Kunden', 'Kundenstamm', Null, 1)
INSERT INTO Stamm..Datensicherung VALUES ('KundenGrp', 'Kundengruppenstamm', Null, 1)
INSERT INTO Stamm..Datensicherung VALUES ('KundenGrpZuord', 'Kundengruppenzuordnung', Null, 1)
INSERT INTO Stamm..Datensicherung VALUES ('PflVersichertenNr', 'Pflegeversichertennummernstamm', Null, 1)
INSERT INTO Stamm..Datensicherung VALUES ('VersichertenNr', 'Versichertennummernstamm', Null, 1)
GO


IF EXISTS (SELECT name FROM sysobjects WHERE name = 'Firmenstamm' AND type = 'U')
  DROP TABLE Firmenstamm
GO
CREATE TABLE Firmenstamm
(
	  IK         int PRIMARY KEY  
	, Inhaber    varchar(40)    NULL
	, ApoName    varchar(40)    NULL
	, Strasse    varchar(40)    NULL
	, Plz        varchar(10)    NULL
	, Ort        varchar(40)    NULL
	, Nation     varchar(3)     NULL
	, Bundesland varchar(50)    NULL
	, Telefon    varchar(30)    NULL
	, FAX        varchar(30)    NULL
	, eMail      varchar(30)    NULL
	, PrivateKey varchar(5000)  NULL
	, PublicKey  varchar(5000)  NULL
	, RZ         int            NULL
	, IsHauptApo bit            NULL
	, HauptApoIK int            NULL
	, IDF        int            NULL
	, KundenNr   int            NULL
	, AntragNr   int            NULL
)
GO

--INSERT INTO Firmenstamm VALUES (301234561, 'Dieter Demomann', 'Demo-Haupt-Apotheke', 'Bauerland 3', '28259', 'Bremen', 'DE', 'Bremen', '0421 - 57 62 126', '0421 - 57 62 299', '', '', '', 0, 0, 0, 0, 0, 0)
--GO



--- Kassen ---
IF EXISTS (SELECT name FROM sysobjects WHERE name = 'Kassen' AND type = 'U')
  DROP TABLE Kassen
GO
--- Kassen ---
IF EXISTS (SELECT name FROM sysobjects WHERE name = 'Kassen' AND type = 'U')
  DROP TABLE Kassen
GO
CREATE TABLE [dbo].[Kassen](
	[KassenIK] [int] NULL,
	[KostentraegerIK] [int] NULL,
	[Kassenart] [tinyint] NULL,
	[KurzBez] [char](3) NULL,
	[KassenName] [varchar](60) NULL,
	[Strasse] [varchar](34) NULL,
	[Plz] [varchar](10) NULL,
	[Ort] [varchar](30) NULL,
	[Telefon] [varchar](20) NULL,
	[FAX] [varchar](20) NULL,
	[FusionsIK] [int] NULL,
	[JJMM] [int] NOT NULL DEFAULT ((9912)),
	[IsValid] [bit] NOT NULL DEFAULT ((1)),
	[ID] [int] IDENTITY(1,1) NOT NULL,
PRIMARY KEY CLUSTERED 
(
	[ID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON, FILLFACTOR = 90) ON [PRIMARY]
) ON [PRIMARY]
GO
CREATE INDEX KassenIdx0 ON Kassen (KassenIK)
GO
CREATE INDEX KassenIdx1 ON Kassen (KostentraegerIK)
GO
GRANT SELECT ON Kassen TO PUBLIC
GO


---
--- View KassenDistinct. Bei doppelten KassenIK KostentrgerIK Kombinationen wird die Kasse mit der niedrigsten ID bernommen.
---
IF EXISTS (SELECT name FROM sysobjects WHERE name = 'KassenDistinct' AND type = 'V')
  DROP VIEW KassenDistinct
GO

CREATE VIEW KassenDistinct AS SELECT * FROM Kassen WHERE ID IN (SELECT MIN(ID) FROM Kassen GROUP BY KassenIK, KostentraegerIK)
GO


---
--- Tabelle der Kassedaten um zwei Spalten erweitern.
---
IF EXISTS (SELECT name FROM sysobjects WHERE name = 'Kassen' AND type = 'U')
BEGIN

	IF NOT EXISTS (SELECT * FROM sys.tables t INNER JOIN sys.columns c ON t.object_id = c.object_id AND c.name = 'JJMM' AND t.name = 'Kassen')
	BEGIN
	
		ALTER TABLE Kassen ADD JJMM    INT NOT NULL  Default 9912      --- Monat der Bereitstellung
		ALTER TABLE Kassen ADD IsValid BIT NOT NULL  Default 1         --- TRUE Datensatz aktuell gltig, FALSE Historien Datensatz.
		ALTER TABLE Kassen ADD ID      INT Identity(1, 1) PRIMARY KEY  --- Eindeutige Zeilen-ID.

	END

END
GO


---
--- View KassenDistinct. Bei doppelten KassenIK KostentrgerIK Kombinationen wird die Kasse mit der niedrigsten ID bernommen.
---
IF EXISTS (SELECT name FROM sysobjects WHERE name = 'KassenDistinct' AND type = 'V')
  DROP VIEW KassenDistinct
GO

CREATE VIEW KassenDistinct AS SELECT * FROM Kassen WHERE ID IN (SELECT MIN(ID) FROM Kassen GROUP BY KassenIK, KostentraegerIK)
GO


--- PflegeKassen ---
IF EXISTS (SELECT name FROM sysobjects WHERE name = 'PflegeKassen' AND type = 'U')
  DROP TABLE PflegeKassen
GO
CREATE TABLE PflegeKassen
(
   PflKassenIK      int PRIMARY KEY
 , PflKassenArt     int
 , PflKassenName1   varchar(100) NULL
 , PflKassenName2   varchar(100) NULL
 , PflKurzBez       varchar(3)   NULL
 , Strasse          varchar(100) NULL
 , Plz              varchar(10)  NULL
 , Ort              varchar(100) NULL
 , Telefon          varchar(30)  NULL
 , FAX              varchar(30)  NULL
 , eMail            varchar(50)  NULL
 , WebSeite         varchar(50)  NULL
 , Hotline          varchar(100) NULL
 , Bemerkung        varchar(200) NULL
)
GO

IF EXISTS (SELECT name FROM sysobjects WHERE name = 'PDFAbr' AND type = 'U')
  DROP TABLE PDFAbr
GO
CREATE TABLE PDFAbr
(
   ApoIK            int            NOT NULL
 , JJJJMM           int            NOT NULL
 , PDFByteData      VarBinary(max) NOT NULL
 , DataSize         int            NOT NULL
 , IsOnlineData     Bit            NOT NULL
)
GO
CREATE UNIQUE INDEX PDFAbr_Idx0 ON PDFAbr (ApoIK, JJJJMM)
GO


IF EXISTS (SELECT name FROM sysobjects WHERE name = 'ApoPlanerdaten' AND type = 'U')
  DROP TABLE ApoPlanerdaten
GO
CREATE TABLE ApoPlanerdaten
(
   ApoIK               int              NOT NULL
 , JJJJMM              int              NOT NULL
 , byteDataSummen      varBinary(max)   NOT NULL
 , byteDataPositionen  varBinary(max)   NOT NULL
 , SumDataSize         int              NOT NULL
 , PosDataSize         int              NOT NULL
 , IsOnlineData        Bit              NOT NULL
)
GO
CREATE UNIQUE INDEX ApoPlanerdatenIdx0 ON ApoPlanerdaten (ApoIK, JJJJMM)
GO

--- LoadData ---
IF EXISTS (SELECT name FROM sysobjects WHERE name = 'LoadData' AND type = 'U')
  DROP TABLE LoadData
GO

CREATE TABLE LoadData
(
   TabName     varchar(40) PRIMARY KEY --- Name der Tabelle: z. B. ATC, Hersteller, Kassen, Importe ...
 , DataFrom    int                     --- YYYYMMDD "Datum" an dem die Daten erzeugt worden sind (Stand der Daten)
 , LoadedOn    datetime                --- Datum an dem die Daten zuletzt geladen wurden
)
GO


USE STAMM
GO
--- RezeptMemo ---
IF NOT EXISTS (SELECT name FROM sysobjects WHERE name = 'RezeptMemo' AND type = 'U')
BEGIN
CREATE TABLE RezeptMemo
(
   Id           Int    Identity    Primary Key 
 , JJMM         SmallInt
 , Pic          Int
 , ApoIK        Int
 , ByteData     VarBinary(max)     
 , DataSize     Int      
 , RtfData      VarBinary(max)
 , RtfDataSize  Int    
 , Headline     varchar(200)
 , DateFrom     DateTime
 , KategorieNr  Int
 , StatusNr     Int
 , InfoData     VarBinary(max)
 , InfoDataSize Int  
)
CREATE UNIQUE INDEX RezeptMemoIdx0 ON RezeptMemo (JJMM, Pic)
CREATE INDEX RezeptMemoIdx1 ON RezeptMemo (ApoIK)
GRANT SELECT ON RezeptMemo TO PUBLIC
END
GO

IF NOT EXISTS (SELECT name FROM sysobjects WHERE name = 'RezeptMemoKategorien' AND type = 'U')
BEGIN
CREATE TABLE RezeptMemoKategorien
(
   KategorieNr    Int  Identity       PRIMARY KEY
 , KategorieName  Varchar(80)
)
INSERT INTO RezeptMemoKategorien VALUES ('Allgemeines')
INSERT INTO RezeptMemoKategorien VALUES ('apokorrektur')
GRANT SELECT ON RezeptMemoKategorien TO PUBLIC
END
GO

IF NOT EXISTS (SELECT name FROM sysobjects WHERE name = 'RezeptMemoStati' AND type = 'U')
BEGIN
CREATE TABLE RezeptMemoStati
(
   StatusNr    Int  Identity       PRIMARY KEY
 , StatusName  Varchar(80)
)
INSERT INTO RezeptMemoStati VALUES ('offen')
INSERT INTO RezeptMemoStati VALUES ('erledigt')
INSERT INTO RezeptMemoStati VALUES ('in Bearbeitung')
GRANT SELECT ON RezeptMemoStati TO PUBLIC
END
GO


USE STAMM
GO

IF NOT EXISTS (SELECT name FROM sysobjects WHERE name = 'DontShowDocNr' AND type = 'U')
BEGIN

--- DontShowDocNr ---
CREATE TABLE DontShowDocNr
(
   BenutzerNr Int
 , DocNr      Int
)


CREATE INDEX DontShowDocNrIdx0 ON DontShowDocNr(BenutzerNr)

GRANT SELECT ON DontShowDocNr TO PUBLIC

END
GO

--- NutzerDefRecherche ---
IF NOT EXISTS (SELECT name FROM sysobjects WHERE name = 'NutzerDefRecherche' AND type = 'U')
BEGIN
CREATE TABLE NutzerDefRecherche
(
   Id 	   Int    Identity    Primary Key
 , RechercheName     varchar(50)
)
CREATE UNIQUE INDEX NutzerDefRechercheIdx0 ON NutzerDefRecherche (Id, RechercheName)
CREATE INDEX NutzerDefRechercheIdx1 ON NutzerDefRecherche (Id, RechercheName)
GRANT SELECT ON NutzerDefRecherche TO PUBLIC
END
GO

IF NOT EXISTS (SELECT name FROM sysobjects WHERE name = 'NutzerDefRecherchePZN' AND type = 'U')
BEGIN
CREATE TABLE NutzerDefRecherchePZN
(
   Id    Int    Identity    Primary Key   
 , PZNId   Int Not null  
 , PZNListId   Int Not null          
 , PZN  BigInt 
 , Description Varchar(200)
 ) 
GRANT SELECT ON NutzerDefRecherchePZN TO PUBLIC
END
GO

IF NOT EXISTS (SELECT name FROM sysobjects WHERE name = 'NutzerDefRecherchePznList' AND type = 'U')
BEGIN
CREATE TABLE NutzerDefRecherchePznList
(
   Id Int Identity 
 , PZN    BigInt  
 , Description  Varchar(200)
 , ReadOnly bit NOT NULL
 , constraint NutzerDefRecherchePznListPK
        primary key (Id, PZN)
)
INSERT INTO NutzerDefRecherchePznList VALUES(2567142, 'Abrechnung des Zuschlages bei Abgabe von Oseltamivir-Zubereitungen', 1)
INSERT INTO NutzerDefRecherchePznList VALUES(2567484, 'Erythrozytenkonzentrate ohne Pharmazentralnummer', 1)
INSERT INTO NutzerDefRecherchePznList VALUES(2567490, 'Thrombozytenkonzentrate ohne Pharmazentralnummer', 1)
INSERT INTO NutzerDefRecherchePznList VALUES(2567509, 'Plasmen ohne Pharmazentralnummer', 1)
INSERT INTO NutzerDefRecherchePznList VALUES(2567515, 'Granulozyten ohne Pharmzentralnummer', 1)
INSERT INTO NutzerDefRecherchePznList VALUES(2567521, 'Vollblutkonserven ohne Pharmzentralnummer', 1)
INSERT INTO NutzerDefRecherchePznList VALUES(2567538, 'LeukozytenKonzentrate ohne Pharmzentralnummer',1)
INSERT INTO NutzerDefRecherchePznList VALUES(2567544, 'Blutprodukte ohne PZN, soweit nicht mit den Sonderkennzeichen 2567484,2567490, 2567509, 2567515, 2567521 oder 2567538 erfasst', 1)
INSERT INTO NutzerDefRecherchePznList VALUES(9999092, 'Zytostatika-Zubereitungen', 1)
INSERT INTO NutzerDefRecherchePznList VALUES(9999100, 'individuell hergestellte Mittel zur parenteralen Ernhrung', 1)
INSERT INTO NutzerDefRecherchePznList VALUES(9999123, 'individuell hergestellte parenterale antibiotikahaltige Infusionslsungen', 1)
INSERT INTO NutzerDefRecherchePznList VALUES(9999146, 'individuell hergestellte Schmerzlsungen', 1)
INSERT INTO NutzerDefRecherchePznList VALUES(9999152, 'sonstige individuell hergestellte parenterale Lsungen soweit nicht mit den Sonderkennzeichen 9999092, 9999100, 9999123, 9999169 oder 9999146', 1)
INSERT INTO NutzerDefRecherchePznList VALUES(9999169, 'individuell hergestellte parenterale virustatikahaltige Infusionslsungen', 1)
INSERT INTO NutzerDefRecherchePznList VALUES(2566993, 'Abgabe von aus Fertigarzneimitteln entnommenen, patientenindividuellen Teilmengen im Rahmen einer Dauermedikation(z.B. Wochenblister )', 1)
INSERT INTO NutzerDefRecherchePznList VALUES(2567053, 'Auseinzelung', 1)
INSERT INTO NutzerDefRecherchePznList VALUES(2567461, 'Individuell hergestellte parenterale Lsungen mit Folinaten, die keine weiteren Wirkstoffe enthalten', 1)
INSERT INTO NutzerDefRecherchePznList VALUES(2567478, 'Individuell hergestellte parenterale Lsungen mit Monoklonalen Antikrpern', 1)
GRANT SELECT ON NutzerDefRecherchePznList TO PUBLIC
END
GO


IF NOT EXISTS (SELECT name FROM sysobjects WHERE name = 'Neuigkeiten' AND type = 'U')
BEGIN

--- Neuigkeiten ---
CREATE TABLE Neuigkeiten
(
   VersionNr Int PRIMARY KEY
)

GRANT SELECT ON Neuigkeiten TO PUBLIC

END
GO



IF NOT EXISTS (SELECT name FROM sysobjects WHERE name = 'ApoRabattInfo' AND type = 'U')
BEGIN

--- ApoRabattInfo ---
CREATE TABLE ApoRabattInfo
(
   JJJJMM                 int       NOT NULL
 , ApoIK                  int       NOT NULL
 , ApoRabattInCent        int       NOT NULL
 , LastAccessDate         datetime  NOT NULL
 , IsRohgewinnKorrigiert  Bit       NOT NULL --- Der Rohgewinn muss fr 2008, 2009 u. 2010 (bis Nov.) korriegt werden. Irrtmlich wurde der MwSt-Anteil mit abgezogen. ---
)

CREATE UNIQUE INDEX ApoRabattInfoIdx0 ON ApoRabattInfo (JJJJMM, ApoIK)

GRANT SELECT ON ApoRabattInfo TO PUBLIC	

END
GO


IF NOT EXISTS (SELECT name FROM sysobjects WHERE name = 'WindowMemory' AND type = 'U')
BEGIN

CREATE TABLE WindowMemory
(

   BenutzerNr           INT          
 , RechnerName          varchar(40)  
 , WindowName           varchar(100) 
 , Height               INT
 , Width                INT
 , TopY                 INT
 , LeftX                INT
)

CREATE UNIQUE INDEX WindowMemoryIdx0 On WindowMemory (BenutzerNr, RechnerName, WindowName);

GRANT SELECT ON WindowMemory TO PUBLIC

END
GO
